import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;

public class VisualField extends DrawObject
{
	// DrawObject abilities:
	@Override
	public boolean IsVisualField()
	{
		return true;
	}

	@Override
	public boolean CanBeDeletedByUser()
	{
		return true;
	};

	@Override
	public boolean CanBeExcitedByUser()
	{
		return false;
	}

	@Override
	public boolean CanBeMovedByUser()
	{
		return true;
	}

	@Override
	public boolean CanBeSelectedByUser()
	{
		return true;
	}
	// end of DrawObject abilities

	private ArrayList<VisualFieldPixel> Pixels = new ArrayList<VisualFieldPixel>();

	public VisualField(Point Pos)
	{
		SetPos(Pos);
		SetSize(new Point(0, 0)); // should prevent (multi-)selecting VisualField (only its VisualFieldPixels are to be multi-selected)
		InitializeExcitement(ExcitementOnceMilliseconds);
	};

	public void AddVisualFieldPixel(VisualFieldPixel VisualFieldPixel)
	{
		VisualFieldPixel.SetParentDrawObject(this);

		Pixels.add(VisualFieldPixel);
	};

	public ArrayList<VisualFieldPixel> AddVisualFieldPixels()
	{ // spawns child objects

		int PIXEL_DISTANCE = 20;

		long PixelsCompoundId = DrawObject.GetNewCompoundId();

		for (int y = 0; y < 100 / PIXEL_DISTANCE; y++)
		{
			for (int x = 0; x < 100 / PIXEL_DISTANCE; x++)
			{
				VisualFieldPixel VisualFieldPixel = new VisualFieldPixel(new Point(Pos.x + x * PIXEL_DISTANCE, Pos.y + y * PIXEL_DISTANCE)); // use Pos of this VisualField

				VisualFieldPixel.SetCompoundId(PixelsCompoundId);
				VisualFieldPixel.SetParentDrawObject(this);

				Pixels.add(VisualFieldPixel);
			}
		}

		return Pixels;
	};

	@Override
	public void Draw(Graphics g)
	{
		/*
		if (!(IsWithinWindowBounds(this, 0)))
			return;
			
		// background (overdraw grid)
		SetColor(g, Color.LIGHT_GRAY);
		g.fillRect(Pos.x, Pos.y, Size.x, Size.y);
		
		// draw frame
		SetColor(g, Color.BLACK);
		g.drawRect(Pos.x, Pos.y, Size.x, Size.y);
		*/
	}

	@Override
	public ArrayList<DrawObject> GetChildDrawObjects()
	{
		ArrayList<DrawObject> ChildDrawObjects = new ArrayList<DrawObject>();

		for (Iterator<VisualFieldPixel> i = Pixels.iterator(); i.hasNext();)
		{
			VisualFieldPixel o = i.next();
			ChildDrawObjects.add(o);
		}

		return ChildDrawObjects;
	}

	@Override
	protected void MarkAsZombie()
	{
		IsZombie = true;

		for (Iterator<VisualFieldPixel> i = Pixels.iterator(); i.hasNext();)
		{
			VisualFieldPixel o = i.next();
			o.MarkAsZombieForThis();
		}
	}

	@Override
	public void Move(Point MoveAmount)
	{
		for (Iterator<VisualFieldPixel> i = Pixels.iterator(); i.hasNext();)
		{
			VisualFieldPixel o = i.next();
			o.MoveThis(MoveAmount);
		}

		Pos.x += MoveAmount.x;
		Pos.y += MoveAmount.y;
	}

	@Override
	public void SetHighlighted(boolean IsHighlightedNew)
	{
		IsHighlighted = IsHighlightedNew;

		for (Iterator<VisualFieldPixel> i = Pixels.iterator(); i.hasNext();)
		{
			VisualFieldPixel o = i.next();
			o.SetHighlightedForThis(IsHighlighted);
		}
	}

	@Override
	public void SetPartOfMultiSelection(boolean IsPartNew)
	{
		IsPartOfMultiSelection = IsPartNew;

		for (Iterator<VisualFieldPixel> i = Pixels.iterator(); i.hasNext();)
		{
			VisualFieldPixel o = i.next();
			o.SetPartOfMultiSelectionForThis(IsPartOfMultiSelection);
		}
	}

	@Override
	public void SetPos(Point PosNew)
	{
		PosNew = AlignOnGrid(PosNew);

		Point MoveAmount = new Point(PosNew.x - Pos.x, PosNew.y - Pos.y);

		Move(MoveAmount);
	}
}
